/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class NotifyObject
implements Serializable {
    public static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    public static final int ALWAYS = 1;
    public static final int NEVER = 2;
    public static final int CONDITION = 4;
    public static final int VALUE_CHANGED = 5;
    public static final String ALWAYS_STRING = adminRB.getString("s_ALWAYS");
    public static final String NEVER_STRING = adminRB.getString("s_NEVER");
    public static final String CONDITION_STRING = adminRB.getString("s_CONDITION");
    public static final String EQ = "==";
    public static final String NE = "!=";
    public static final String LE = "<=";
    public static final String GE = ">=";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String AUTO = "AUTO";
    private int when;
    private String armOp;
    private float armValue;
    private String rearmOp;
    private float rearmValue;
    private int pollingInterval;
    private boolean storeData = true;

    public NotifyObject(int n, int n2) {
        this.when = n;
        this.pollingInterval = n2;
    }

    public NotifyObject(String string, float f, String string2, float f2, int n) {
        this.when = 4;
        this.armOp = string;
        this.armValue = f;
        this.rearmOp = string2;
        this.rearmValue = f2;
        this.pollingInterval = n;
    }

    public int getWhenToNotify() {
        return this.when;
    }

    public String getArmOp() {
        return this.armOp;
    }

    public float getArmValue() {
        return this.armValue;
    }

    public String getRearmOp() {
        return this.rearmOp;
    }

    public float getRearmValue() {
        return this.rearmValue;
    }

    public boolean getStoreData() {
        return this.storeData;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean equals(NotifyObject notifyObject) {
        return !(this.when != notifyObject.getWhenToNotify() || this.armOp == null && notifyObject.getArmOp() != null || this.armOp != null && !this.armOp.equals(notifyObject.getArmOp()) || this.rearmOp == null && notifyObject.getRearmOp() != null || this.rearmOp != null && !this.rearmOp.equals(notifyObject.getRearmOp()) || this.armValue != notifyObject.getArmValue() || this.rearmValue != notifyObject.getRearmValue() || this.pollingInterval != notifyObject.getPollingInterval()) && this.storeData == notifyObject.getStoreData();
    }

    public void setStoreData(boolean bl) {
        this.storeData = bl;
    }

    public String getIdentifier() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.when);
        stringBuffer.append(this.charVal(this.armOp));
        stringBuffer.append(this.armValue);
        stringBuffer.append(this.charVal(this.rearmOp));
        stringBuffer.append(this.rearmValue);
        stringBuffer.append(this.storeData);
        stringBuffer.append(this.pollingInterval);
        return stringBuffer.toString();
    }

    private String charVal(String string) {
        if (EQ.equals(string)) {
            return "eq";
        }
        if (NE.equals(string)) {
            return "ne";
        }
        if (LE.equals(string)) {
            return "le";
        }
        if (GE.equals(string)) {
            return "ge";
        }
        if (GT.equals(string)) {
            return "gt";
        }
        if (LT.equals(string)) {
            return "lt";
        }
        return string;
    }

    public static Vector getOps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(EQ);
        vector.addElement(NE);
        vector.addElement(LT);
        vector.addElement(LE);
        vector.addElement(GT);
        vector.addElement(GE);
        vector.addElement(AUTO);
        return vector;
    }

    public static Vector getNotifyTypes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(ALWAYS_STRING);
        vector.addElement(NEVER_STRING);
        vector.addElement(CONDITION_STRING);
        return vector;
    }

    public static int toInt(String string) {
        int n = 0;
        if (string.equals(CONDITION_STRING)) {
            n = 4;
        } else if (string.equals(ALWAYS_STRING)) {
            n = 1;
        } else if (string.equals(NEVER_STRING)) {
            n = 2;
        }
        return n;
    }

    public String toString(int n) {
        String string = null;
        switch (n) {
            case 4: {
                string = CONDITION_STRING;
                break;
            }
            case 1: {
                string = ALWAYS_STRING;
                break;
            }
            case 2: {
                string = NEVER_STRING;
                break;
            }
            default: {
                System.err.println("NotifyObject:toString:Invalid when");
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Notify Object:\n");
        stringBuffer.append("\nPolling Interval: " + this.pollingInterval);
        switch (this.when) {
            case 4: {
                stringBuffer.append("\nwhen: CONDITION");
                stringBuffer.append("\narmOp: " + this.armOp);
                stringBuffer.append("\narmValue: " + this.armValue);
                stringBuffer.append("\nrearmOp: " + this.rearmOp);
                stringBuffer.append("\nrearmValue: " + this.rearmValue);
                break;
            }
            case 1: {
                stringBuffer.append("\nwhen: ALWAYS");
                break;
            }
            case 2: {
                stringBuffer.append("\nwhen: NEVER");
                break;
            }
            default: {
                stringBuffer.append("\nInvalid when");
            }
        }
        return stringBuffer.toString();
    }
}

